TITLE   'Forces on a Parallel-Plate Capacitor'			{ exa111.pde }
SELECT     errlim=3e-4     ngrid=1     spectral_colors
VARIABLES   U
DEFINITIONS					
   L=1     xx=0.25     d0=0.1     dd0=0.4*d0      U0=1.0e4	{ Voltage }
   eps0=8.854e-12     eps=eps0			{ Permittivity }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Dex=eps*Ex     Dey=eps*Ey     D=eps*E     Dm=magnitude(D)	
EQUATIONS
   div( D)=0	         				
BOUNDARIES
region 'domain'			
   start 'outer' (-L,-L)   natural(U)=0     		{ Outer boundary }
   line to (L,-L) to (L,L)  to (-L,L) close						
   start 'upper' (-xx,d0) value(U)=U0 		{ Upper plate }
   line to (xx,d0) to (xx,d0+dd0) to (-xx,d0+dd0) close
   start 'lower' (-xx,-d0-dd0) value(U)=0.0	{ Lower plate, ground }
   line to (xx,-d0-dd0) to (xx,-d0) to (-xx,-d0) close
region 'glass'   eps=7.0*eps0          		{ Dielectric }	
   start(-xx,-d0)  line to (xx,-d0)  to (xx,d0) to (-xx,d0) close
PLOTS
   contour( U)     contour( Dm) log     contour( Dm) painted on 'glass'
   vector( D) norm elevation( Dey) from (-L,0) to (L,0)	{ ? Charge }
   elevation( 0.5*normal( D)*Ey) on 'upper'		{ Integral ? force }
   report( -1*2*xx* 0.5*[7*eps0*U0/(2*d0)]* U0/(2*d0)) as 'F_elementary'
END


